<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

trait ArticleDetailStockInfoProviderServiceDecoration
{
    /**
     * @var ArticleDetailStockInfoProvider
     */
    protected $decoratedService;

    /**
     * @see ArticleDetailStockInfoProvider::getStockInWarehouse()
     *
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     * @return int
     */
    public function getStockInWarehouse(ArticleDetail $articleDetail, Warehouse $warehouse)
    {
        return $this->decoratedService->getStockInWarehouse($articleDetail, $warehouse);
    }

    /**
     * @see ArticleDetailStockInfoProvider::getTotalPhysicalStock()
     *
     * @param ArticleDetail $articleDetail
     * @return int
     */
    public function getTotalPhysicalStock(ArticleDetail $articleDetail)
    {
        return $this->decoratedService->getTotalPhysicalStock($articleDetail);
    }

    /**
     * @see ArticleDetailStockInfoProvider::getTotalPhysicalStockForSale()
     *
     * @param ArticleDetail $articleDetail
     * @return int
     */
    public function getTotalPhysicalStockForSale(ArticleDetail $articleDetail)
    {
        return $this->decoratedService->getTotalPhysicalStockForSale($articleDetail);
    }

    /**
     * @see ArticleDetailStockInfoProvider::getLatestStockLedgerEntryForWarehouse()
     *
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     * @param string|null $stockLedgerEntryType (optional)
     * @return StockLedgerEntry|null
     */
    public function getLatestStockLedgerEntryForWarehouse(
        ArticleDetail $articleDetail,
        Warehouse $warehouse,
        $stockLedgerEntryType = null
    ) {
        return $this->decoratedService->getLatestStockLedgerEntryForWarehouse(
            $articleDetail,
            $warehouse,
            $stockLedgerEntryType
        );
    }

    /**
     * @see ArticleDetailStockInfoProvider::isStockManaged()
     *
     * @param ArticleDetail $articleDetail
     * @return boolean
     */
    public function isStockManaged(ArticleDetail $articleDetail)
    {
        return $this->decoratedService->isStockManaged($articleDetail);
    }

    /**
     * @see ArticleDetailStockInfoProvider::isStockInitialized()
     *
     * @param ArticleDetail $articleDetail
     * @return boolean
     */
    public function isStockInitialized(ArticleDetail $articleDetail)
    {
        return $this->decoratedService->isStockInitialized($articleDetail);
    }
}
