<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\PurchasePriceAssignment;

use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;

/**
 * Simple class to model a list item of a pricelist as well as a pricing item.
 */
class AssignablePurchasePrice
{

    /**
     * @var float|null
     */
    private $price;

    /**
     * @var integer
     */
    private $quantity;

    /**
     * @var StockLedgerEntry
     */
    private $stockLedgerEntry;

    public function __construct($price, $quantity, StockLedgerEntry $stockLedgerEntry = null)
    {
        $this->price = $price;
        $this->quantity = $quantity;
        $this->stockLedgerEntry = $stockLedgerEntry;
    }

    /**
     * Sets the items price to a given value
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    /**
     * Returns the price of the item
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the quantity of the item to a given value
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }

    /**
     * Returns the quantity of the item
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Sets the stock entry of the item to a given one
     */
    public function setStockentry(StockLedgerEntry $stockLedgerEntry)
    {
        $this->stockLedgerEntry = $stockLedgerEntry;
    }

    /**
     * Returns the stock entry of the item
     */
    public function getStockentry()
    {
        return $this->stockLedgerEntry;
    }
}
