<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\PurchasePriceAssignment;

/**
 * The default pricing assigns the default purchase price of the associated
 * article to all items, which should be priced.
 */
class FallbackPurchasePriceAssignment extends AbstractPurchasePriceAssignment
{
    /**
     * @inheritdoc
     */
    protected function generatePricingAssignments()
    {
        return [new AssignablePurchasePrice($this->defaultPrice, $this->quantity)];
    }
}
