<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\PurchasePriceAssignment;

use Shopware\Components\Model\ModelManager;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

/**
 * The purchase pricing assigns a given purchase price to all items, which
 * should be priced.
 */
class IncomingPurchasePriceAssignment extends AbstractPurchasePriceAssignment
{
    /**
     * Purchase price, which should be assigned to all items.
     *
     * @var float
     */
    protected $price;

    /**
     * Adds the purchase price to the parameter list of the default constructor.
     *
     * @param ModelManager $entityManager
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     * @param int $quantity
     * @param float $price
     */
    public function __construct(ModelManager $entityManager, ArticleDetail $articleDetail, Warehouse $warehouse, $quantity, $price)
    {
        $this->price = $price;
        parent::__construct($entityManager, $articleDetail, $warehouse, $quantity);
    }

    /**
     * @inheritdoc
     */
    protected function generatePricingAssignments()
    {
        return [new AssignablePurchasePrice($this->price, $this->quantity)];
    }
}
