<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\PurchasePriceAssignment;

/**
 * The purchase pricing assigns "no" price to all items, which should be priced. This pricing is used when no actual
 * stock change took place (e.g. change of bin location) and therefore no purchase price is relevant.
 */
class NullPurchasePriceAssignment extends AbstractPurchasePriceAssignment
{
    /**
     * @inheritdoc
     */
    protected function generatePricingAssignments()
    {
        return [new AssignablePurchasePrice(null, $this->quantity)];
    }
}
