<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\PurchasePriceAssignment;

trait PricingBucketSelection
{
    /**
     * Selects as many of the given pricing `$buckets` as necessary and in reverse order to cover the given `$quantity`.
     * That is, the last element of `$buckets` is selected first. When reaching a bucket that exceeds the reamining
     * quantity, a partial bucket is created with that reamining quantity.
     *
     * @param AssignablePurchasePrice[] $buckets
     * @param int $quantity
     * @return AssignablePurchasePrice[]
     */
    protected static function reverselySelectPricingBuckets(array $buckets, $quantity)
    {
        $selectedBuckets = [];
        while (count($buckets) > 0 && $quantity > 0) {
            $pricingBucket = array_pop($buckets);
            if ($pricingBucket->getQuantity() < $quantity) {
                $selectedBuckets[] = $pricingBucket;
                $quantity -= $pricingBucket->getQuantity();
            } else {
                $selectedBuckets[] = new AssignablePurchasePrice(
                    $pricingBucket->getPrice(),
                    $quantity,
                    $pricingBucket->getStockentry()
                );
                break;
            }
        }

        return $selectedBuckets;
    }
}
