<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\BinLocation;

/**
 * @internal
 */
class BinLocationStockChange
{
    /**
     * @var BinLocation $binLocation
     */
    private $binLocation;

    /**
     * @var int $stockChange
     */
    private $stockChange;

    /**
     * @param BinLocation $binLocation
     * @param int $stockChange
     * @throws \InvalidArgumentException
     */
    public function __construct(BinLocation $binLocation, $stockChange)
    {
        if (!$binLocation) {
            throw new \InvalidArgumentException('Parameter "binLocation" must not be null.');
        }

        $this->binLocation = $binLocation;
        $this->stockChange = $stockChange;
    }

    /**
     * @return BinLocation
     */
    public function getBinLocation()
    {
        return $this->binLocation;
    }

    /**
     * @return int
     */
    public function getStockChange()
    {
        return $this->stockChange;
    }

    /**
     * @param int $stockChange
     */
    public function setStockChange($stockChange)
    {
        $this->stockChange = $stockChange;
    }
}
