<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList;

/**
 * @internal Use the service `pickware.erp.stock_change_list_factory_service` to generte stock change lists instead.
 */
class PositiveStockChangeList extends AbstractStockChangeList
{
    /**
     * @Inheritdoc
     */
    protected function validateBinLocationStockChange(BinLocationStockChange $change)
    {
        // Make sure the passed change has a positive stock change
        if ($change->getStockChange() < 0) {
            throw new \InvalidArgumentException('A PositiveStockChangeList accepts only instances of BinLocationStockChange whose "stockChange" is greater than or equal zero');
        }

        return true;
    }
}
