<?php

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class StockChangeListFactoryException extends \Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        $this->snippetName = $snippetName;
        $this->snippetNamespace  = 'viison_pickware_erp/components/stock_ledger/stock_change_list_factory';
        $this->snippetArguments = $snippetArguments;

        parent::__construct(vsprintf($message, $snippetArguments));
    }

    /**
     * @return self
     */
    public static function stockChangeZero()
    {
        return new self(
            'A stock change must not be zero.',
            'exceptions/stock_change_zero'
        );
    }
}
