<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\ArticleDetailBinLocationMapping;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\BinLocation;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

trait StockChangeListFactoryServiceDecoration
{
    /**
     * @var StockChangeListFactory
     */
    protected $decoratedService;

    /**
     * @see StockChangeListFactory::createSingleBinLocationStockChangeList()
     *
     * @param BinLocation $binLocation
     * @param int $stockChange
     * @return PositiveStockChangeList|NegativeStockChangeList
     */
    public function createSingleBinLocationStockChangeList(BinLocation $binLocation, $stockChange)
    {
        return $this->decoratedService->createSingleBinLocationStockChangeList($binLocation, $stockChange);
    }

    /**
     * @see StockChangeListFactory::createStockChangeList()
     *
     * @param Warehouse $warehouse
     * @param ArticleDetail $articleDetail
     * @param int $changeAmount
     * @return PositiveStockChangeList|NegativeStockChangeList
     */
    public function createStockChangeList(Warehouse $warehouse, ArticleDetail $articleDetail, $changeAmount)
    {
        return $this->decoratedService->createStockChangeList($warehouse, $articleDetail, $changeAmount);
    }

    /**
     * @see StockChangeListFactory::createPickingStockChangesFromBinLocationMappings()
     *
     * @param int $quantity
     * @param ArticleDetailBinLocationMapping[] $binLocationMappings
     * @param BinLocation $fallbackBinLocation
     * @return BinLocationStockChange[]
     */
    public function createPickingStockChangesFromBinLocationMappings(
        $quantity,
        array $binLocationMappings,
        BinLocation $fallbackBinLocation
    ) {
        return $this->decoratedService->createPickingStockChangesFromBinLocationMappings(
            $quantity,
            $binLocationMappings,
            $fallbackBinLocation
        );
    }
}
