<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\BinLocation;

class ZeroStockChangeList extends AbstractStockChangeList
{
    public static function fromBinLocation(BinLocation $binLocation)
    {
        return new self([
            new BinLocationStockChange($binLocation, 0),
        ]);
    }

    /**
     * @Inheritdoc
     */
    protected function validateBinLocationStockChange(BinLocationStockChange $change)
    {
        // Make sure the passed change has a positive stock change
        if ($change->getStockChange() !== 0) {
            throw new \InvalidArgumentException('A ZeroStockChangeList accepts only instances of BinLocationStockChange whose "stockChange" equals zero');
        }

        return true;
    }
}
