<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use Shopware\Models\Article\Detail as ArticleDetail;

trait StockInitializationServiceDecoration
{
    /**
     * @var StockInitialization
     */
    protected $decoratedService;

    /**
     * @see StockInitialization::initializeStocksOfAllUninitializedArticleDetails()
     *
     * @throws StockLedgerConcurrencyException
     */
    public function initializeStocksOfAllUninitializedArticleDetails()
    {
        $this->decoratedService->initializeStocksOfAllUninitializedArticleDetails();
    }

    /**
     * @see StockInitialization::initializeStocksOfUninitializedArticleDetailsBatchWise()
     *
     * @param int|null $batchSize
     * @return int The number of stocks which are not yet initialized
     * @throws StockLedgerConcurrencyException
     */
    public function initializeStocksForABatchOfUninitializedArticleDetails($batchSize = StockInitialization::DEFAULT_BATCH_SIZE)
    {
        return $this->decoratedService->initializeStocksForABatchOfUninitializedArticleDetails($batchSize);
    }

    /**
     * @see StockInitialization::initializeStocksOfArticleDetails()
     *
     * @param ArticleDetail[] $articleDetails
     * @throws StockLedgerConcurrencyException
     */
    public function initializeStocksOfArticleDetails(array $articleDetails)
    {
        $this->decoratedService->initializeStocksOfArticleDetails($articleDetails);
    }

    /**
     * @see StockInitialization::getAllUninitializedArticleDetails()
     *
     * @return array
     */
    public function getAllUninitializedArticleDetails()
    {
        return $this->decoratedService->getAllUninitializedArticleDetails();
    }

    /**
     * @see StockInitialization::getPaginatedUninitializedArticleDetails()
     *
     * @param string|null $filterStr
     * @param string|null $orderBy
     * @param string|null $direction
     * @param int $start
     * @param int $limit
     * @return array
     */
    public function getPaginatedUninitializedArticleDetails(
        $filterStr = null,
        $orderBy = null,
        $direction = null,
        $start = 0,
        $limit = 0
    ) {
        return $this->decoratedService->getPaginatedUninitializedArticleDetails(
            $filterStr,
            $orderBy,
            $direction,
            $start,
            $limit
        );
    }
}
