<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use OverflowException;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockItem;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;
use Shopware\Models\Article\Detail as ArticleDetail;

interface StockItemUpdater
{
    /**
     * Adds all given $propertyValues to the given $stockEntry by creating as many stock entry items as necessary before
     * assigning the values. Finally the created stock entry items are returned.
     *
     * @param StockLedgerEntry $stockEntry
     * @param array[] $propertyValues
     * @return StockItem[]
     * @throws OverflowException If the number of given $propertyValues exceeds the remaining quantity of the stock
     *                           entry that is not assigned stock entry items yet.
     */
    public function addStockItemsWithProperties(StockLedgerEntry $stockEntry, array $propertyValues);

    /**
     * Creates a new StockItem for the given $stockEntry and assigns all given $propertyValues.
     *
     * @param StockLedgerEntry $stockEntry
     * @param array $propertyValues (optional)
     * @return StockItem
     */
    public function addStockItem(StockLedgerEntry $stockEntry, array $propertyValues = []);

    /**
     * Adds all given $propertyValues to the given $stockEntryItem by either creating new or updating existing stock
     * entry item property for all given values.
     *
     * @param StockItem $stockEntryItem
     * @param array $propertyValues
     */
    public function updateStockItemPropertyValues(StockItem $stockEntryItem, array $propertyValues);

    /**
     * @param StockLedgerEntry $stockEntry
     * @param int $quantity
     * @return boolean
     */
    public function canAddStockItems(StockLedgerEntry $stockEntry, $quantity);
}
