<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use OverflowException;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockItem;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;

trait StockItemUpdaterServiceDecoration
{
    /**
     * @var StockItemUpdater
     */
    protected $decoratedService;

    /**
     * @see StockItemUpdater::addStockItemsWithProperties()
     *
     * @param StockLedgerEntry $stockEntry
     * @param array[] $propertyValues
     * @return StockItem[]
     * @throws OverflowException
     */
    public function addStockItemsWithProperties(StockLedgerEntry $stockEntry, array $propertyValues)
    {
        return $this->decoratedService->addStockItemsWithProperties($stockEntry, $propertyValues);
    }

    /**
     * @see StockItemUpdater::addStockItem()
     *
     * @param StockLedgerEntry $stockEntry
     * @param array $propertyValues (optional)
     * @return StockItem
     */
    public function addStockItem(StockLedgerEntry $stockEntry, array $propertyValues = [])
    {
        return $this->decoratedService->addStockItem($stockEntry, $propertyValues);
    }

    /**
     * @see StockItemUpdater::updateStockItemPropertyValues()
     *
     * @param StockItem $stockEntryItem
     * @param array $propertyValues
     */
    public function updateStockItemPropertyValues(StockItem $stockEntryItem, array $propertyValues)
    {
        $this->decoratedService->updateStockItemPropertyValues($stockEntryItem, $propertyValues);
    }

    /**
     * @see StockItemUpdater::canAddStockItems()
     *
     * @param StockLedgerEntry $stockEntry
     * @param int $quantity
     * @return boolean
     */
    public function canAddStockItems(StockLedgerEntry $stockEntry, $quantity)
    {
        return $this->decoratedService->canAddStockItems($stockEntry, $quantity);
    }
}
