<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

class StockLedgerConcurrencyException extends StockLedgerException
{
    /**
     * @param ArticleDetail $articleDetail
     * @param Warehouse $warehouse
     * @return self
     */
    public static function concurrentStockInitialization(ArticleDetail $articleDetail, Warehouse $warehouse)
    {
        $messageArguments = [
            $articleDetail->getNumber(),
            $warehouse->getDisplayName(),
        ];
        $exception = new self(
            vsprintf('Article detail with order number %s is already initialized in warehouse %s.', $messageArguments),
            409 // Based on http (409 Conflict)
        );
        $exception->setSnippetName('stock_manager_concurrency_exception/concurrent_stock_initialization');
        $exception->setSnippetArguments($messageArguments);

        return $exception;
    }
}
