<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use Exception;
use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;
use Shopware\Plugins\ViisonCommon\Components\GlobalLocking\GlobalLockingException;

class StockLedgerException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @inheritdoc
     */
    public function __construct($message, $code = 0, Exception $previousException = null)
    {
        parent::__construct($message, $code, $previousException);
        $this->setSnippetNamespace('services/viison_pickware_erp/stock_manager');
    }

    /**
     * @param ArticleDetail $articleDetail
     * @return self
     */
    public static function stockTakeRequiresInitialization(ArticleDetail $articleDetail)
    {
        $messageArguments = [
            $articleDetail->getNumber(),
        ];

        $exception = new self(
            vsprintf(
                'The stocktake for variant #%s cannot be created, because its stock has not been initialized yet.',
                $messageArguments
            )
        );

        $exception->setSnippetArguments($messageArguments);
        $exception->setSnippetName('stock_manager_exception/stock_take_requires_initialization');

        return $exception;
    }
}
