<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockLedger;

use Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipmentItem;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;
use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Models\Order\Detail as OrderDetail;
use Shopware\Models\User\User;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList\NegativeStockChangeList;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList\PositiveStockChangeList;

interface StockUpdater
{
    /**
     * Creates one or more new stock entries for the managed article detail in the managed warehouse representing a
     * change in the `$orderDetail`'s `shipped` quantity.
     *
     * @param ArticleDetail $articleDetail
     * @param OrderDetail $orderDetail
     * @param PositiveStockChangeList|NegativeStockChangeList $stockChanges
     * @param User|null $user
     * @return StockLedgerEntry[]
     */
    public function recordOrderDetailShippedChange(
        ArticleDetail $articleDetail,
        OrderDetail $orderDetail,
        $stockChanges,
        User $user = null
    );

    /**
     * @param ArticleDetail $articleDetail
     * @param ReturnShipmentItem $returnShipmentItem
     * @param PositiveStockChangeList|NegativeStockChangeList $stockChanges
     * @param User|null $user
     * @return StockLedgerEntry[]
     */
    public function recordReturnShipmentItemReturnedChange(
        ArticleDetail $articleDetail,
        ReturnShipmentItem $returnShipmentItem,
        $stockChanges,
        User $user = null
    );

    /**
     * @param ArticleDetail $articleDetail
     * @param ReturnShipmentItem $returnShipmentItem
     * @param PositiveStockChangeList|NegativeStockChangeList $stockChanges
     * @param User|null $user
     * @return StockLedgerEntry[]
     */
    public function recordReturnShipmentItemWriteOffChange(
        ArticleDetail $articleDetail,
        ReturnShipmentItem $returnShipmentItem,
        $stockChanges,
        User $user = null
    );

    /**
     * @param ArticleDetail $articleDetail
     * @param $stockChanges
     * @param User|null $user
     * @return StockLedgerEntry[]
     */
    public function recordArticleDetailStockChange(
        ArticleDetail $articleDetail,
        $stockChanges,
        User $user = null
    );
}
