<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockMovement;

class StockMovementException extends \Exception
{
    /**
     * @return self
     */
    public static function warehouseNotFound()
    {
        return new self('The passed warehouse does not exist.');
    }

    /**
     * @return self
     */
    public static function binLocationNotFound()
    {
        return new self('The passed bin location does not exist.');
    }

    /**
     * @return self
     */
    public static function notEnoughStockOnBinLocation()
    {
        return new self('The passed bin location does not contain sufficient stock to perform the requested operation.');
    }
}
