<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockMovement;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\ArticleDetailStockInfoProvider;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList\StockChangeListFactory;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockLedgerService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockUpdater;

class WarehouseStockLocation extends AbstractStockLocation
{
    /**
     * @var StockChangeListFactory
     */
    protected $stockChangeListFactory;

    /**
     * @var ArticleDetailStockInfoProvider
     */
    protected $articleDetailStockInfoProvider;

    /**
     * @var Warehouse
     */
    protected $warehouse;

    /**
     * @param StockLedgerService $stockLedgerService
     * @param StockUpdater $stockUpdater
     * @param StockChangeListFactory $stockChangeListFactory
     * @param ArticleDetailStockInfoProvider $articleDetailStockInfoProvider
     * @param Warehouse $warehouse
     */
    public function __construct(
        StockLedgerService $stockLedgerService,
        StockUpdater $stockUpdater,
        StockChangeListFactory $stockChangeListFactory,
        ArticleDetailStockInfoProvider $articleDetailStockInfoProvider,
        Warehouse $warehouse
    ) {
        parent::__construct($stockLedgerService, $stockUpdater);
        $this->stockChangeListFactory = $stockChangeListFactory;
        $this->articleDetailStockInfoProvider = $articleDetailStockInfoProvider;
        $this->warehouse = $warehouse;
    }

    /**
     * @inheritDoc
     */
    protected function createStockChangeListForArticleDetail(ArticleDetail $articleDetail, $quantity)
    {
        return $this->stockChangeListFactory->createStockChangeList($this->warehouse, $articleDetail, $quantity);
    }

    /**
     * @inheritDoc
     */
    protected function calculateTotalStockOfArticleDetail(ArticleDetail $articleDetail)
    {
        return $this->articleDetailStockInfoProvider->getStockInWarehouse($articleDetail, $this->warehouse);
    }
}
