<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockReservation;

use Shopware\CustomModels\ViisonPickwareERP\StockLedger\OrderStockReservation;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Models\Order\Detail as OrderDetail;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList\BinLocationStockChange;

trait StockReservationServiceDecoration
{
    /**
     * @var StockReservation
     */
    protected $decoratedService;

    /**
     * @see StockReservation::reserveOpenQuantityForOrderDetail()
     *
     * @param Warehouse $warehouse
     * @param OrderDetail $orderDetail
     * @return OrderStockReservation[]
     */
    public function reserveOpenQuantityForOrderDetail(Warehouse $warehouse, OrderDetail $orderDetail)
    {
        return $this->decoratedService->reserveOpenQuantityForOrderDetail($warehouse, $orderDetail);
    }

    /**
     * @see StockReservation::reserveOpenQuantityForOrderDetail()
     *
     * @param ArticleDetail $articleDetail
     * @param OrderDetail $orderDetail
     * @param BinLocationStockChange[] $stockChanges
     * @return OrderStockReservation[]
     */
    public function reserveStockForStockChanges(
        ArticleDetail $articleDetail,
        OrderDetail $orderDetail,
        array $stockChanges
    ) {
        return $this->decoratedService->reserveOpenQuantityForOrderDetail($articleDetail, $orderDetail, $stockChanges);
    }

    /**
     * @see StockReservation::clearStockReservation()
     *
     * @param OrderStockReservation $reservation
     */
    public function clearStockReservation(OrderStockReservation $reservation)
    {
        $this->decoratedService->clearStockReservation($reservation);
    }

    /**
     * @see StockReservation::clearStockReservationsForOrderDetail()
     *
     * @param Warehouse $warehouse
     * @param OrderDetail $orderDetail
     */
    public function clearStockReservationsForOrderDetail(Warehouse $warehouse, OrderDetail $orderDetail)
    {
        $this->decoratedService->clearStockReservationsForOrderDetail($warehouse, $orderDetail);
    }
}
