<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\StockValuation;

use Dompdf\Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class StockValuationException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     */
    public function __construct($message, $snippetName)
    {
        parent::__construct($message, 0);
        $this->snippetNamespace = 'viison_pickware_erp/components/stock_valuation/stock_valuation_exception';
        $this->snippetName = $snippetName;
    }

    /**
     * @return self
     */
    public static function youngerReportExists()
    {
        return new self('There is already a report that includes this reporting day.', 'younger_report_exists');
    }

    /**
     * @return self
     */
    public static function reportDoesNotFullyIncludeReportingDay()
    {
        return new self(
            'A report can only be persisted if the reporting day is fully included.',
            'report_does_not_fully_include_reporting_day'
        );
    }
}
