<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Supplier;

use Shopware\Plugins\ViisonCommon\Classes\Exceptions\NumberRangeNotFoundException;

interface SupplierNumberGenerator
{
    /**
     * Checks whether or not the given supplier number is already used.
     *
     * @param string $supplierNumber
     * @return bool
     */
    public function isSupplierNumberAvailable($supplierNumber);

    /**
     * Returns the next unused supplier number.
     *
     * @return int
     * @throws NumberRangeNotFoundException if the number range could not be found
     */
    public function generateSupplierNumber();
}
