<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Supplier;

use Shopware\Plugins\ViisonCommon\Classes\Exceptions\NumberRangeNotFoundException;

trait SupplierNumberGeneratorServiceDecoration
{
    /**
     * @var SupplierNumberGenerator
     */
    protected $decoratedService;

    /**
     * @see SupplierNumberGenerator::isSupplierNumberAvailable()
     *
     * @param string $supplierNumber
     * @return bool
     */
    public function isSupplierNumberAvailable($supplierNumber)
    {
        return $this->decoratedService->isSupplierNumberAvailable($supplierNumber);
    }

    /**
     * @see SupplierNumberGenerator::generateSupplierNumber()
     *
     * @return int
     * @throws NumberRangeNotFoundException
     */
    public function generateSupplierNumber()
    {
        return $this->decoratedService->generateSupplierNumber();
    }
}
