<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Warehouse;

interface BinLocationCodeGenerator
{
    /**
     * Returns a new linked bin location code component that is based on the given `$rawComponents`, if they are valid.
     *
     * @param array[] $rawComponents
     * @return BinLocationCodeComponent
     * @throws BinLocationCodeGeneratorException if the passed `$rawComponents` are invalid.
     */
    public function createLinkedCodeComponent(array $rawComponents);

    /**
     * @param array[] $rawComponents
     * @return boolean True, iff all elements in the given `$rawComponents` are valid raw code components.
     */
    public function areRawCodeComponentsValid(array $rawComponents);
}
