<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Warehouse;

trait BinLocationCodeGeneratorServiceDecoration
{
    /**
     * @var BinLocationCodeGenerator
     */
    protected $decoratedService;

    /**
     * @see BinLocationCodeGenerator::createLinkedCodeComponent()
     *
     * @param array[] $rawComponents
     * @return BinLocationCodeComponent
     * @throws BinLocationCodeGeneratorException
     */
    public function createLinkedCodeComponent(array $rawComponents)
    {
        return $this->decoratedService->createLinkedCodeComponent($rawComponents);
    }

    /**
     * @see BinLocationCodeGenerator::areRawCodeComponentsValid()
     *
     * @param array[] $rawComponents
     * @return boolean
     */
    public function areRawCodeComponentsValid(array $rawComponents)
    {
        return $this->decoratedService->areRawCodeComponentsValid($rawComponents);
    }
}
