<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Warehouse;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

interface WarehouseIntegrity
{
    /**
     * Ensures that exactly one warehouse is marked as the default warehouse.
     */
    public function ensureSingleDefaultWarehouse();

    /**
     * Ensures that exactly one warehouse is marked as the default return shipment warehouse.
     */
    public function ensureSingleDefaultReturnShipmentWarehouse();

    /**
     * Ensures that all article details have bin location mappings and warehouse stock counts in the given `$warehouse`.
     *
     * @param Warehouse $warehouse
     */
    public function ensureMappingsForAllArticleDetailsInWarehouse(Warehouse $warehouse);

    /**
     * Ensures that the given `$articleDetail` has bin location mappings and warehouse stock counts in all warehouses.
     *
     * @param ArticleDetail $articleDetail
     */
    public function ensureAllWarehouseMappingsForArticleDetail(ArticleDetail $articleDetail);

    /**
     * Evaluates all constraints on the deletion of the given `$warehouse` and returns any detected violations.
     *
     * @param Warehouse $warehouse
     * @return string[]
     */
    public function evaluateWarehouseDeletionConstraints(Warehouse $warehouse);
}
