<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Components\Warehouse;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

trait WarehouseIntegrityServiceDecoration
{
    /**
     * @var WarehouseIntegrity
     */
    protected $decoratedService;

    /**
     * @see WarehouseIntegrity::ensureSingleDefaultWarehouse()
     */
    public function ensureSingleDefaultWarehouse()
    {
        $this->decoratedService->ensureSingleDefaultWarehouse();
    }

    /**
     * @see WarehouseIntegrity::ensureSingleDefaultReturnShipmentWarehouse()
     */
    public function ensureSingleDefaultReturnShipmentWarehouse()
    {
        $this->decoratedService->ensureSingleDefaultReturnShipmentWarehouse();
    }

    /**
     * @see WarehouseIntegrity::ensureMappingsForAllArticleDetailsInWarehouse()
     *
     * @param Warehouse $warehouse
     */
    public function ensureMappingsForAllArticleDetailsInWarehouse(Warehouse $warehouse)
    {
        $this->decoratedService->ensureMappingsForAllArticleDetailsInWarehouse($warehouse);
    }

    /**
     * @see WarehouseIntegrity::ensureAllWarehouseMappingsForArticleDetail()
     *
     * @param ArticleDetail $articleDetail
     */
    public function ensureAllWarehouseMappingsForArticleDetail(ArticleDetail $articleDetail)
    {
        $this->decoratedService->ensureAllWarehouseMappingsForArticleDetail($articleDetail);
    }

    /**
     * @see WarehouseIntegrity::evaluateWarehouseDeletionConstraints()
     *
     * @param Warehouse $warehouse
     * @return string[]
     */
    public function evaluateWarehouseDeletionConstraints(Warehouse $warehouse)
    {
        return $this->decoratedService->evaluateWarehouseDeletionConstraints($warehouse);
    }
}
