<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Classes\Util\Localization as LocalizationUtil;
use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPAboutBackend extends ViisonCommonBaseController
{
    /**
     * Disables the JSON renderer for getContent requests.
     */
    public function preDispatch()
    {
        if ($this->Request()->getActionName() !== 'getContent') {
            parent::preDispatch();
        }
    }

    /**
     * Loads the content template depending on the current backend locale. Use english template as a fallback.
     */
    public function getContentAction()
    {
        $backendLocaleString = $this->get('auth')->getIdentity()->locale->getLocale();
        // Shorten the locale to use more general language code (e.g. 'en_GB' -> 'en')
        $backendLocaleString = LocalizationUtil::getLanguageCode($backendLocaleString);

        $templatePath = 'backend/viison_pickware_erp_about_backend/content.' . $backendLocaleString . '.tpl';
        if (file_exists(__DIR__ . '/../../Views/' . $templatePath)) {
            $this->View()->loadTemplate($templatePath);
        } else {
            // Use english template as fallback
            $this->View()->loadTemplate('backend/viison_pickware_erp_about_backend/content.en.tpl');
        }
    }
}
