<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Models\Shop\Shop;
use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPAboutContact extends ViisonCommonBaseController
{

    /**
     * Set view params to use in backend/viison_pickware_erp_about/contact mail dialog
     *
     * @return array
     */
    public function getViewParams()
    {
        $shopURL = $this->get('models')->getRepository(Shop::class)->getDefault()->getHost();

        return [
            'pickwarePluginVersion' => Shopware()->Plugins()->Core()->ViisonPickwareERP()->getVersion(),
            'shopwareVersion' => Shopware()->Config()->version,
            'shopURL' => $shopURL,
        ];
    }

    /**
     * Gets and checks the email information from the request and uses it to create and send
     * and email.
     */
    public function sendEmailAction()
    {
        // Get email data
        $toAddress = trim($this->Request()->getParam('toAddress'));
        $subject = trim($this->Request()->getParam('subject'));
        $content = trim($this->Request()->getParam('content'));
        if (empty($toAddress) || empty($subject) || empty($content)) {
            $this->View()->success = false;

            return;
        }

        // Create email
        $mail = clone Shopware()->Mail();
        $mail->clearFrom();
        $mail->setFrom(Shopware()->Config()->Mail);
        $mail->clearRecipients();
        $mail->addTo($toAddress);
        $mail->setSubject($subject);
        $mail->setBodyText($content);

        // Try to send email
        try {
            $mail->send();
            $this->View()->success = true;
        } catch (Exception $e) {
            $this->View()->success = false;
        }
    }
}
