<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPAboutPopup extends ViisonCommonBaseController
{
    /**
     * Updates the 'displayPickwareAboutWindow' config element of this plugin using the 'hideDialogInTheFuture' value
     * contained in the request.
     */
    public function saveAction()
    {
        // Save the user choice in the config element
        $showDialogInTheFuture = $this->Request()->getParam('hideDialogInTheFuture') !== 'true';
        $this->get('pickware.erp.plugin_config_service')->setDisplayAboutPickwareErpWindow($showDialogInTheFuture);
    }
}
