<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPIndexNewsWidget extends ViisonCommonBaseController
{
    const NEWS_FEED_URL = 'http://www.pickware.de/blog/rss';

    /**
     * Returns the most recent news as array
     */
    public function getNewsAction()
    {
        // Load data
        $data = $this->getParsedNews(self::NEWS_FEED_URL);
        if (!$data) {
            $this->View()->assign([
                'success' => false,
                'data' => null,
                'total' => 0,
            ]);

            return;
        }

        // Respons at most 'limit' news entries
        $limit = $this->Request()->getParam('limit', 5);
        $data = array_slice($data, 0, min(count($data), $limit));
        $this->View()->assign([
            'success' => true,
            'data' => $data,
            'total' => count($data),
        ]);
    }

    /**
     * Returns an array of parsed News Objects from xml URL
     *
     * @param $url
     * @return array|null
     */
    private function getParsedNews($url)
    {
        // Load the XML source
        $source = file_get_contents($url);
        $list = simplexml_load_string($source, 'SimpleXMLElement', LIBXML_NOCDATA);
        if (!$list) {
            return null;
        }

        // Fetch relevant information
        $newsItems = $list->xpath('//channel/item');
        $result = array_map(
            function ($item) {
                $linkWithUtmParams = $item->link . '?utm_source=backend.shopware&utm_medium=widget';

                return [
                    'title' => (string)$item->title,
                    'link' => $linkWithUtmParams,
                    'linkHash' => sha1($linkWithUtmParams),
                    'date' => new \DateTime($item->pubDate),
                ];
            },
            $newsItems
        );

        return $result;
    }
}
