<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

/**
 * This controller provides a backend action for all articles for uninitialized stock.
 */
class Shopware_Controllers_Backend_ViisonPickwareERPIndexStockCheck extends ViisonCommonBaseController
{
    /**
     * Responds the number of articles, whose stock has not been initialized yet.
     */
    public function checkStockAction()
    {
        $articles = $this->get('pickware.erp.stock_initialization_service')->getAllUninitializedArticleDetails();
        $this->View()->count = $articles['total'];
    }
}
