<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Models\Document\Document as DocumentType;
use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPOrderDocumentCreation extends ViisonCommonBaseController
{
    /**
     * Pass the document id of pick list document type as view parameter.
     *
     * @return array
     */
    public function getViewParams()
    {
        /** @var DocumentType|null $documentType */
        $documentType = $this->get('pickware.erp.plugin_config_service')->getPickListDocumentType();

        return [
            'viisonPickListDocumentId' => $documentType ? $documentType->getId() : null,
        ];
    }
}
