<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPPluginManagerPickwareModules extends ViisonCommonBaseController
{
    /**
     * Disables the JSON renderer for content requests.
     */
    public function preDispatch()
    {
        if (!in_array($this->Request()->getActionName(), ['getPickwareMobileDescriptionContent', 'getPickwarePOSDescriptionContent'])) {
            parent::preDispatch();
        }
    }

    /**
     * Responds with the Pickware POS description content.
     */
    public function getPickwareMobileDescriptionContentAction()
    {
        $this->View()->loadTemplate('backend/viison_pickware_erp_plugin_manager_pickware_modules/content/description_pickware_mobile.tpl');
    }

    /**
     * Responds with the Pickware POS description content.
     */
    public function getPickwarePOSDescriptionContentAction()
    {
        $this->View()->loadTemplate('backend/viison_pickware_erp_plugin_manager_pickware_modules/content/description_pickware_pos.tpl');
    }
}
