<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonPickwareERPSystemInfo extends ViisonCommonBaseController
{
    /**
     * Checks the plugin for a MD5 checksums file and, if exists, compares it agains the plugin files.
     */
    public function getFileListAction()
    {
        $pluginDirectory = __DIR__ . '/../../';
        $fileName = $pluginDirectory . 'files.md5sums';
        if (!is_file($fileName)) {
            $this->View()->assign([
                'success' => true,
                'data' => [],
            ]);

            return;
        }

        // Skip files from check
        $skipList = [
            './files.md5sums'
        ];

        $list = new Shopware_Components_Check_File($fileName, $pluginDirectory, $skipList);

        $this->View()->assign([
            'success' => true,
            'data' => $list->toArray(),
        ]);
    }
}
