<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Controllers;

/**
 * Helper class to hold event names on const variables.
 *
 * If you are using a const in a controller, other plugins subscribers may not be able to use this controller property,
 * if the subscriber is loaded before the controller was registered (via another subscriber). Hence we need this static
 * class to access the properties safely.
 */
class ControllerEvents
{
    const NOTIFY_UNTIL_PREVENT_BIN_LOCATION_DELETION = 'Shopware_Controllers_Api_ViisonPickwareERPBinLocations_NotifyUntil_PreventBinLocationDeletion';
}
