<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\BarcodeLabel;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;

/**
 * @ORM\Entity(repositoryClass="Repository")
 * @ORM\Table(name="pickware_erp_barcode_label_preset_blocks")
 */
class BarcodeLabelPresetBlock extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="presetId", type="integer", nullable=false)
     */
    private $presetId;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="value", type="text", nullable=false)
     */
    private $value;

    /**
     * OWNING SIDE
     *
     * @var BarcodeLabelPreset
     *
     * @ORM\ManyToOne(targetEntity="BarcodeLabelPreset", inversedBy="blocks")
     * @ORM\JoinColumn(name="presetId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $preset;

    /**
     * @param BarcodeLabelPreset $preset
     */
    public function __construct(BarcodeLabelPreset $preset)
    {
        $this->setPreset($preset);
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return BarcodeLabelPreset
     */
    public function getPreset()
    {
        return $this->preset;
    }

    /**
     * @param BarcodeLabelPreset $preset
     */
    public function setPreset(BarcodeLabelPreset $preset)
    {
        $this->preset = $preset;
        if (!$this->preset->getBlocks()->contains($this)) {
            $this->preset->getBlocks()->add($this);
        }
    }
}
