<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ItemProperty;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\CustomModels\ViisonPickwareERP\ItemProperty\ItemProperty;
use Shopware\Models\Article\Detail as ArticleDetail;

/**
 * @ORM\Entity(repositoryClass="ArticleDetailItemPropertyRepository")
 * @ORM\Table(name="pickware_erp_article_detail_item_properties", uniqueConstraints={
 *      @ORM\UniqueConstraint(name="articleDetailId_propertyTypeId", columns={
 *          "articleDetailId",
 *          "itemPropertyId"
 *      })
 * })
 */
class ArticleDetailItemProperty extends ModelEntity
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Id
     */
    protected $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="articleDetailId", type="integer", nullable=false, options={"unsigned":true})
     */
    protected $articleDetailId;

    /**
     * OWNING SIDE
     *
     * @var ArticleDetail
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Article\Detail")
     * @ORM\JoinColumn(name="articleDetailId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $articleDetail;

    /**
     * @var integer
     *
     * @ORM\Column(name="itemPropertyId", type="integer", nullable=false)
     */
    protected $itemPropertyId;

    /**
     * OWNING SIDE
     *
     * @var ItemProperty
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\ItemProperty\ItemProperty")
     * @ORM\JoinColumn(name="itemPropertyId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $itemProperty;

    /**
     * @param ArticleDetail $articleDetail
     * @param ItemProperty $itemProperty
     */
    public function __construct(ArticleDetail $articleDetail, ItemProperty $itemProperty)
    {
        $this->articleDetail = $articleDetail;
        $this->itemProperty = $itemProperty;

        // Explicitely set the both IDs which form the unique identifier of this entity, because Doctrine
        // won't do it, even though we have already set the assocaited entitis
        $this->articleDetailId = $articleDetail->getId();
        $this->itemPropertyId = $itemProperty->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return ArticleDetail
     */
    public function getArticleDetail()
    {
        return $this->articleDetail;
    }

    /**
     * @return ItemProperty
     */
    public function getItemProperty()
    {
        return $this->itemProperty;
    }
}
