<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ItemProperty;

use Shopware\Components\Model\ModelRepository;

class ArticleDetailItemPropertyRepository extends ModelRepository
{
    /**
     * Fetches the property type mappings of all aricle details having one of the given $articleDetailIds and returns an
     * array grouped by article detail ID of the mapped property types as arrays.
     *
     * @param int[] $articleDetailIds
     * @return array[]
     */
    public function getAssignedItemPropertiesAsArrays(array $articleDetailIds)
    {
        if (count($articleDetailIds) === 0) {
            return [];
        }

        // Fetch all property type mappings for the given article detail IDs
        $builder = $this->getEntityManager()->createQueryBuilder();
        $builder
            ->select(
                'mapping',
                'itemProperty'
            )
            ->from(ArticleDetailItemProperty::class, 'mapping')
            ->leftJoin('mapping.itemProperty', 'itemProperty')
            ->where('mapping.articleDetailId IN (:articleDetailIds)')
            ->setParameter('articleDetailIds', $articleDetailIds);
        $result = $builder->getQuery()->getArrayResult();

        // Extract the property types and group them by article detail
        $groupedResult = [];
        foreach ($result as $row) {
            if (!isset($groupedResult[$row['articleDetailId']])) {
                $groupedResult[$row['articleDetailId']] = [];
            }
            $groupedResult[$row['articleDetailId']][] = $row['itemProperty'];
        }

        return $groupedResult;
    }
}
