<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\RestApi;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_rest_api_requests",options={"row_format"="COMPRESSED"})
 */
class RestApiRequest extends ModelEntity
{
    /**
     * @var int $id
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \DateTime $date
     *
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @var string $method
     *
     * @ORM\Column(name="method", type="string", length=55, nullable=true)
     */
    private $method;

    /**
     * @var string $url
     *
     * @ORM\Column(name="url", type="text", nullable=true)
     */
    private $url;

    /**
     * @var string $requestHeaders
     *
     * @ORM\Column(name="requestHeaders", type="text", nullable=true)
     */
    private $requestHeaders;

    /**
     * @var string $requestData
     *
     * @ORM\Column(name="requestData", type="text", nullable=true)
     */
    private $requestData;

    /**
     * @var int $responseCode
     *
     * @ORM\Column(name="responseCode", type="integer", nullable=true)
     */
    private $responseCode;

    /**
     * @var string $responseHeaders
     *
     * @ORM\Column(name="responseHeaders", type="text", nullable=true)
     */
    private $responseHeaders;

    /**
     * @var string $responseData
     *
     * @ORM\Column(name="responseData", type="text", nullable=true)
     */
    private $responseData;

    /**
     * @var string $exception
     *
     * @ORM\Column(name="exception", type="text", nullable=true)
     */
    private $exception;

    /**
     * @var string $user
     *
     * @ORM\Column(name="user", type="string", length=255, nullable=true)
     */
    private $user;

    /**
     * @var string $ipAddress
     *
     * @ORM\Column(name="ipAddress", type="string", length=255, nullable=true)
     */
    private $ipAddress;

    /**
     * @var string $userAgent
     *
     * @ORM\Column(name="userAgent", type="string", length=255, nullable=true)
     */
    private $userAgent;

    /**
     * @var float $computationTime
     *
     * @ORM\Column(name="computationTime", type="float", nullable=true)
     */
    private $computationTime;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idempotentOperationId", type="integer", nullable=true)
     */
    private $idempotentOperationId;

    /**
     * OWNING SIDE
     *
     * @var RestApiIdempotentOperation|null
     *
     * @ORM\ManyToOne(targetEntity="RestApiIdempotentOperation", inversedBy="requests")
     * @ORM\JoinColumn(name="idempotentOperationId", referencedColumnName="id", onDelete="SET NULL")
     */
    private $idempotentOperation;

    public function __construct()
    {
        $this->date = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate(\DateTime $date)
    {
        $this->date = $date;
    }

    /**
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * @param string $method
     */
    public function setMethod($method)
    {
        $this->method = $method;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getRequestHeaders()
    {
        return $this->requestHeaders;
    }

    /**
     * @param string $requestHeaders
     */
    public function setRequestHeaders($requestHeaders)
    {
        $this->requestHeaders = $requestHeaders;
    }

    /**
     * @return string
     */
    public function getRequestData()
    {
        return $this->requestData;
    }

    /**
     * @param string $requestData
     */
    public function setRequestData($requestData)
    {
        $this->requestData = $requestData;
    }

    /**
     * @return int
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }

    /**
     * @param int $responseCode
     */
    public function setResponseCode($responseCode)
    {
        $this->responseCode = $responseCode;
    }

    /**
     * @return string
     */
    public function getResponseHeaders()
    {
        return $this->responseHeaders;
    }

    /**
     * @param string $responseHeaders
     */
    public function setResponseHeaders($responseHeaders)
    {
        $this->responseHeaders = $responseHeaders;
    }

    /**
     * @return string
     */
    public function getResponseData()
    {
        return $this->responseData;
    }

    /**
     * @param string $responseData
     */
    public function setResponseData($responseData)
    {
        $this->responseData = $responseData;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = $exception;
    }

    /**
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param string $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }

    /**
     * @param string $ipAddress
     */
    public function setIpAddress($ipAddress)
    {
        $this->ipAddress = $ipAddress;
    }

    /**
     * @return string
     */
    public function getUserAgent()
    {
        return $this->userAgent;
    }

    /**
     * @param string $userAgent
     */
    public function setUserAgent($userAgent)
    {
        $this->userAgent = $userAgent;
    }

    /**
     * @return float|null
     */
    public function getComputationTime()
    {
        return $this->computationTime;
    }

    /**
     * @param float|null $computationTime
     */
    public function setComputationTime($computationTime)
    {
        $this->computationTime = $computationTime;
    }

    /**
     * @return RestApiIdempotentOperation|null
     */
    public function getIdempotentOperation()
    {
        return $this->idempotentOperation;
    }

    /**
     * @param RestApiIdempotentOperation|null $idempotentOperation
     */
    public function setIdempotentOperation(RestApiIdempotentOperation $idempotentOperation = null)
    {
        if ($this->idempotentOperation) {
            $this->idempotentOperation->getRequests()->remove($this);
        }

        $this->idempotentOperation = $idempotentOperation;

        if ($this->idempotentOperation && !$this->idempotentOperation->getRequests()->contains($this)) {
            $this->idempotentOperation->getRequests()->add($this);
        }
    }
}
