<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ReturnShipment;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Plugins\ViisonCommon\Classes\Util\Util as ViisonCommonUtil;

// In SW 5.6 they removed the `legacy_documentid_converter` service, so we have to check via version to use the correct
// column.
if (ViisonCommonUtil::assertMinimumShopwareVersion('5.6.0')
    || (
        Shopware()->Container()->has('legacy_documentid_converter')
        && !Shopware()->Container()->get('legacy_documentid_converter')->isDocumentIdUpperCase()
    )
) {
    /**
     * @ORM\Table(name="pickware_erp_return_shipments")
     * @ORM\Entity(repositoryClass="ReturnShipmentRepository")
     * @ORM\AssociationOverrides({
     *     @ORM\AssociationOverride(
     *         name="document",
     *         joinColumns=@ORM\JoinColumn(name="documentId", referencedColumnName="id")
     *     ),
     * })
     */
    class ReturnShipment extends AbstractReturnShipment
    {
    }
} else {
    /**
     * @ORM\Table(name="pickware_erp_return_shipments")
     * @ORM\Entity(repositoryClass="ReturnShipmentRepository")
     * @ORM\AssociationOverrides({
     *     @ORM\AssociationOverride(
     *         name="document",
     *         joinColumns=@ORM\JoinColumn(name="documentId", referencedColumnName="ID")
     *     ),
     * })
     */
    class ReturnShipment extends AbstractReturnShipment // phpcs:ignore PSR1.Classes.ClassDeclaration.MultipleClasses
    {
    }
}
