<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ReturnShipment;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Media\Media;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_return_shipment_attachments")
 */
class ReturnShipmentAttachment extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="returnShipmentId", type="integer", nullable=false)
     */
    private $returnShipmentId;

    /**
     * @var int
     *
     * @ORM\Column(name="mediaId", type="integer", nullable=false)
     */
    private $mediaId;

    /**
     * OWNING SIDE
     *
     * @var ReturnShipment
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment", inversedBy="attachments")
     * @ORM\JoinColumn(name="returnShipmentId", referencedColumnName="id")
     */
    protected $returnShipment;

    /**
     * OWNING SIDE
     *
     * @var Media
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Media\Media")
     * @ORM\JoinColumn(name="mediaId", referencedColumnName="id")
     */
    protected $media;

    /**
     * @param ReturnShipment $returnShipment
     * @param Media $media
     */
    public function __construct(ReturnShipment $returnShipment, Media $media)
    {
        $this->returnShipment = $returnShipment;
        $this->media = $media;
        $this->returnShipment->getAttachments()->add($this);
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return ReturnShipment
     */
    public function getReturnShipment()
    {
        return $this->returnShipment;
    }

    /**
     * @return Media
     */
    public function getMedia()
    {
        return $this->media;
    }
}
