<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ReturnShipment;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\User\User;
use \DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_return_shipment_internal_comments")
 */
class ReturnShipmentInternalComment extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="userId", type="integer", nullable=true)
     */
    private $userId = null;

    /**
     * @var int
     *
     * @ORM\Column(name="returnShipmentId", type="integer", nullable=false)
     */
    private $returnShipmentId;

    /**
     * OWNING SIDE
     *
     * @var ReturnShipment
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\ReturnShipment\ReturnShipment", inversedBy="internalComments")
     * @ORM\JoinColumn(name="returnShipmentId", referencedColumnName="id")
     */
    private $returnShipment;

    /**
     * OWNING SIDE
     *
     * @var User|null
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\User\User")
     * @ORM\JoinColumn(name="userId", referencedColumnName="id")
     */
    private $user = null;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="created", type="datetime", nullable=false)
     */
    private $created;

    /**
     * @var string
     *
     * @ORM\Column(name="comment", type="text", nullable=false)
     */
    private $comment = '';

    /**
     * @param ReturnShipment $returnShipment
     */
    public function __construct(ReturnShipment $returnShipment)
    {
        $this->returnShipment = $returnShipment;
        $this->returnShipment->addInternalComment($this);
        $this->created = new DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return ReturnShipment
     */
    public function getReturnShipment()
    {
        return $this->returnShipment;
    }

    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * @return User|null
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param User|null $user
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;
    }

    /**
     * @return DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param DateTime $created
     */
    public function setCreated(DateTime $created)
    {
        $this->created = $created;
    }
}
