<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\ReturnShipment;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;

/**
 * @ORM\Entity(repositoryClass="ReturnShipmentRepository")
 * @ORM\Table(name="pickware_erp_return_shipment_statuses")
 */
class ReturnShipmentStatus extends ModelEntity
{
    const STATUS_RECEIVED_NAME = 'received';
    const STATUS_RECEIVED_ID = 1;
    const STATUS_COMPLETED_NAME = 'completed';
    const STATUS_COMPLETED_ID = 2;
    const STATUS_CANCELLED_NAME = 'cancelled';
    const STATUS_CANCELLED_ID = 3;
    const STATUS_NEW_NAME = 'new';
    const STATUS_NEW_ID = 4;

    /**
     * @var int $id
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer", nullable=false)
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="processStep", type="integer", nullable=false)
     */
    private $processStep;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getProcessStep()
    {
        return $this->processStep;
    }

    /**
     * @param int $processStep
     */
    public function setProcessStep($processStep)
    {
        $this->processStep = $processStep;
    }
}
