<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\StockLedger;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;

/**
 * @ORM\Entity(repositoryClass="StockItemRepository")
 * @ORM\Table(name="pickware_erp_stock_items")
 */
class StockItem extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Id
     */
    protected $id;

    /**
     * @var int
     *
     * @ORM\Column(name="stockLedgerEntryId", type="integer", nullable=false)
     */
    protected $stockLedgerEntryId;

    /**
     * OWNING SIDE
     *
     * @var StockLedgerEntry
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry", inversedBy="stockItems")
     * @ORM\JoinColumn(name="stockLedgerEntryId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $stockLedgerEntry;

    /**
     * INVERSE SIDE
     *
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockItemPropertyValue", mappedBy="stockItem")
     */
    protected $propertyValues;

    /**
     * @param StockLedgerEntry $stockLedgerEntry
     */
    public function __construct(StockLedgerEntry $stockLedgerEntry)
    {
        $this->stockLedgerEntry = $stockLedgerEntry;
        $this->stockLedgerEntry->getStockItems()->add($this);
        $this->propertyValues = new ArrayCollection();

        // Manually set the IDs of the associated entities, because doctrine won't do it in constructors
        $this->stockLedgerEntryId = $this->stockLedgerEntry->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return StockLedgerEntry
     */
    public function getStockLedgerEntry()
    {
        return $this->stockLedgerEntry;
    }

    /**
     * @return ArrayCollection
     */
    public function getPropertyValues()
    {
        return $this->propertyValues;
    }
}
