<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\StockLedger;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\CustomModels\ViisonPickwareERP\ItemProperty\ItemProperty;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_stock_item_property_values", uniqueConstraints={
 *      @ORM\UniqueConstraint(name="stockEntryItemId_propertyTypeId", columns={
 *          "stockItemId",
 *          "itemPropertyId"
 *      })
 * })
 */
class StockItemPropertyValue extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\GeneratedValue(strategy="IDENTITY")
     * @ORM\Id
     */
    protected $id;

    /**
     * @var int
     *
     * @ORM\Column(name="stockItemId", type="integer", nullable=false)
     */
    protected $stockItemId;

    /**
     * OWNING SIDE
     *
     * @var StockItem
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockItem", inversedBy="propertyValues")
     * @ORM\JoinColumn(name="stockItemId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $stockItem;

    /**
     * @var int
     *
     * @ORM\Column(name="itemPropertyId", type="integer", nullable=false)
     */
    protected $itemPropertyId;

    /**
     * OWNING SIDE
     *
     * @var ItemProperty
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\ItemProperty\ItemProperty")
     * @ORM\JoinColumn(name="itemPropertyId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $itemProperty;

    /**
     * @var string
     *
     * @ORM\Column(name="value", type="text", nullable=true)
     */
    protected $value = null;

    /**
     * @param StockItem $stockItem
     * @param ItemProperty $itemProperty
     */
    public function __construct(StockItem $stockItem, ItemProperty $itemProperty)
    {
        $this->stockItem = $stockItem;
        $this->stockItem->getPropertyValues()->add($this);
        $this->itemProperty = $itemProperty;

        // Manually set the IDs of the associated entities, because doctrine won't do it in constructors
        $this->stockItemId = $this->stockItem->getId();
        $this->itemPropertyId = $this->itemProperty->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return StockItem
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }

    /**
     * @return ItemProperty
     */
    public function getItemProperty()
    {
        return $this->itemProperty;
    }

    /**
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
}
