<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\StockLedger;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_warehouse_article_detail_stock_counts", uniqueConstraints={
 *      @ORM\UniqueConstraint(name="warehouseId_articleDetailId", columns={
 *          "warehouseId",
 *          "articleDetailId"
 *      })
 * })
 */
class WarehouseArticleDetailStockCount extends ModelEntity
{
    /**
     * @var int $id
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int $warehouseId
     *
     * @ORM\Column(name="warehouseId", type="integer", nullable=false)
     */
    private $warehouseId;

    /**
     * @var int $articleDetailId
     *
     * @ORM\Column(name="articleDetailId", type="integer", nullable=false, options={"unsigned"=true})
     */
    private $articleDetailId;

    /**
     * @var string $stock
     *
     * @ORM\Column(name="stock", type="integer", nullable=false)
     */
    private $stock = 0;

    /**
     * @var string $incomingStock
     *
     * @ORM\Column(name="incomingStock", type="integer", nullable=false)
     */
    private $incomingStock = 0;

    /**
     * @var string $reservedStock
     *
     * @ORM\Column(name="reservedStock", type="integer", nullable=false)
     */
    private $reservedStock = 0;

    /**
     * OWNING SIDE
     *
     * @var Warehouse
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse", inversedBy="articleDetailStockCounts")
     * @ORM\JoinColumn(name="warehouseId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $warehouse;

    /**
     * OWNING SIDE
     *
     * @var ArticleDetail
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Article\Detail")
     * @ORM\JoinColumn(name="articleDetailId", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $articleDetail;

    /**
     * @param Warehouse $warehouse
     * @param ArticleDetail $articleDetail
     */
    public function __construct(Warehouse $warehouse, ArticleDetail $articleDetail)
    {
        $this->warehouse = $warehouse;
        $this->articleDetail = $articleDetail;

        // Explicitely set the both IDs which form the unique identifier of this entity, because Doctrine
        // won't do it, even though we have already set the associated entities
        $this->warehouseId = $warehouse->getId();
        $this->articleDetailId = $articleDetail->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getStock()
    {
        return $this->stock;
    }

    /**
     * @param int $stock
     */
    public function setStock($stock)
    {
        $this->stock = $stock;
    }

    /**
     * @return int
     */
    public function getIncomingStock()
    {
        return $this->incomingStock;
    }

    /**
     * @param int $incomingStock
     */
    public function setIncomingStock($incomingStock)
    {
        $this->incomingStock = $incomingStock;
    }

    /**
     * @return int
     */
    public function getReservedStock()
    {
        return $this->reservedStock;
    }

    /**
     * @param int $reservedStock
     */
    public function setReservedStock($reservedStock)
    {
        $this->reservedStock = $reservedStock;
    }

    /**
     * @return Warehouse
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }

    /**
     * @return ArticleDetail
     */
    public function getArticleDetail()
    {
        return $this->articleDetail;
    }
}
