<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\StockValuation;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_stock_valuation_report_purchases")
 */
class ReportPurchase
{
    /**
     *
     */
    const TYPE_PURCHASE = 'purchase';
    /**
     *
     */
    const TYPE_CARRY_OVER = 'carry-over';
    /**
     *
     */
    const TYPES = [
        self::TYPE_PURCHASE,
        self::TYPE_CARRY_OVER,
    ];

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var ReportRow
     *
     * @ORM\ManyToOne(targetEntity="ReportRow")
     * @ORM\JoinColumn(name="reportRowId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $reportRow;

    /**
     * @var DateTimeInterface
     *
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @var float
     *
     * @ORM\Column(type="float")
     */
    private $purchasePriceNet;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     */
    private $quantity;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     */
    private $quantityUsedForValuation;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    private $type;

    /**
     * @var StockLedgerEntry|null
     *
     * @ORM\OneToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\StockLedger\StockLedgerEntry")
     * @ORM\JoinColumn(name="purchaseStockLedgerEntryId", referencedColumnName="id", onDelete="SET NULL")
     */
    private $purchaseStockLedgerEntry;

    /**
     * @var ReportRow|null
     *
     * @ORM\OneToOne(targetEntity="ReportRow")
     * @ORM\JoinColumn(name="carryOverReportRowId", referencedColumnName="id", onDelete="SET NULL")
     */
    private $carryOverReportRowId;

    private function __construct()
    {
        // This entity is created via SQL by the StockValuationService
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return ReportRow
     */
    public function getReportRow()
    {
        return $this->reportRow;
    }

    /**
     * @return DateTimeInterface
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return float
     */
    public function getPurchasePriceNet()
    {
        return $this->purchasePriceNet;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @return int
     */
    public function getquantityUsedForValuation()
    {
        return $this->quantityUsedForValuation;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return StockLedgerEntry|null
     */
    public function getPurchaseStockLedgerEntry()
    {
        return $this->purchaseStockLedgerEntry;
    }

    /**
     * @return ReportRow|null
     */
    public function getCarryOverReportRowId()
    {
        return $this->carryOverReportRowId;
    }
}
