<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\StockValuation;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Article\Detail as ArticleDetail;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_stock_valuation_report_rows")
 */
class ReportRow extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var Report
     *
     * @ORM\ManyToOne(targetEntity="Report", inversedBy="rows")
     * @ORM\JoinColumn(name="reportId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $report;

    /**
     * @var ArticleDetail|null
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Article\Detail")
     * @ORM\JoinColumn(name="articleDetailId", referencedColumnName="id", onDelete="SET NULL")
     */
    private $articleDetail;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    private $articleDetailName;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    private $articleDetailNumber;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     */
    private $stock;

    /**
     * @var float|null
     *
     * @ORM\Column(type="float")
     */
    private $valuationNet;

    /**
     * @var float|null
     *
     * @ORM\Column(type="float")
     */
    private $valuationGross;

    /**
     * @var float
     *
     * @ORM\Column(type="float")
     */
    private $taxRate;

    /**
     * @var float
     *
     * @ORM\Column(type="float")
     */
    private $averagePurchasePriceNet;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="ReportPurchase", mappedBy="reportRow")
     */
    private $purchases;

    /**
     * @var int
     *
     * If there is more stock than the sum of purchased stock, this is the surplus stock, that is not
     * included in purchases
     *
     * @ORM\Column(type="integer")
     */
    private $surplusStock = 0;

    /**
     * @var float
     *
     * The surplus stock will be valued by a "guessed" purchase price. This purchase price is saved for
     * documentation.
     *
     * @ORM\Column(type="float")
     */
    private $surplusPurchasePriceNet = null;

    private function __construct()
    {
        // This entity is created via SQL by the StockValuationService
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Report
     */
    public function getReport()
    {
        return $this->report;
    }

    /**
     * @return ArticleDetail|null
     */
    public function getArticleDetail()
    {
        return $this->articleDetail;
    }

    /**
     * @return string
     */
    public function getArticleDetailName()
    {
        return $this->articleDetailName;
    }

    /**
     * @return string
     */
    public function getArticleDetailNumber()
    {
        return $this->articleDetailNumber;
    }

    /**
     * @return int
     */
    public function getStock()
    {
        return $this->stock;
    }

    /**
     * @return float|null
     */
    public function getValuationNet()
    {
        return $this->valuationNet;
    }

    /**
     * @return float|null
     */
    public function getValuationGross()
    {
        return $this->valuationGross;
    }

    /**
     * @return float
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }

    /**
     * @return float
     */
    public function getAveragePurchasePriceNet()
    {
        return $this->averagePurchasePriceNet;
    }

    /**
     * @return ArrayCollection
     */
    public function getPurchases()
    {
        return $this->purchases;
    }

    /**
     * @return int
     */
    public function getSurplusStock()
    {
        return $this->surplusStock;
    }

    /**
     * @return float|null
     */
    public function getSurplusPurchasePriceNet()
    {
        return $this->surplusPurchasePriceNet;
    }
}
