<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\Supplier;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Article\Supplier as Manufacturer;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_manufacturer_supplier_mappings", uniqueConstraints={
 *      @ORM\UniqueConstraint(name="supplier_fabricator", columns={
 *          "supplierId",
 *          "manufacturerId"
 *      })
 * })
 */
class ManufacturerSupplierMapping extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="supplierId", type="integer", nullable=false)
     */
    private $supplierId;

    /**
     * @var int
     *
     * @ORM\Column(name="manufacturerId", type="integer", nullable=false)
     */
    private $manufacturerId;

    /**
     * @var Supplier
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\Supplier\Supplier", inversedBy="manufacturerSupplierMappings")
     * @ORM\JoinColumn(name="supplierId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $supplier;

    /**
     * @var Manufacturer
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Article\Supplier")
     * @ORM\JoinColumn(name="manufacturerId", referencedColumnName="id", onDelete="CASCADE")
     */
    private $manufacturer;

    /**
     * @param Manufacturer $manufacturer
     * @param Supplier $supplier
     */
    public function __construct(Manufacturer $manufacturer, Supplier $supplier)
    {
        $this->manufacturer = $manufacturer;
        $this->supplier = $supplier;
        $this->supplier->getManufacturerSupplierMappings()->add($this);

        // Explicitly set the both IDs which form the unique identifier of this entity, because Doctrine won't do it,
        // even though we have already set the associated entities
        $this->manufacturerId = $manufacturer->getId();
        $this->supplierId = $supplier->getId();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Supplier
     */
    public function getSupplier()
    {
        return $this->supplier;
    }

    /**
     * @return Manufacturer
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
}
